#ifndef ZMODELER_STRUCT_ABSTRACT_H_INCLUDED
#define ZMODELER_STRUCT_ABSTRACT_H_INCLUDED

/****************************************
  3D Basement Abstract Class
****************************************/

class DllExport tAbstract
{
public:
//-------------------
//  data members  
  FlagInt nFlags;  //state of the element.
  
  DWORD  nMiscFlags[Z3D_NUMMISCFLAGS]; //external custom flags.

  DWORD      nRequire;  //Z3D_PLUGRESULT_ bits that forces redraw/rebuild
//-------------------
//  construnction
  tAbstract();//inits all flags with zeros

//-------------------
//  functions.
  DWORD  GetMiscFlag(int index);    //returns the nMiscFlags[index]
  void  SetMiscFlag(int index, DWORD val);//sets value in nMiscFlags[index];
//--------------------------
//  overload-able functions
  virtual void SetFlag(FlagInt F);  //sets Z3D_FALG_ to nFlags
  virtual void UnSetFlag(FlagInt F);  //removes Z3D_FALG_ to nFlags
  virtual BOOL HasFlag(FlagInt F);  //TRUE is specified Z3D_FALG_ is in nFlags
  virtual FlagInt GetSimpleFlags();  //returns "state" flags of nFlags.
  virtual BOOL Selected();      //TRUE if has Z3D_FALG_SELECTED in nFlags
  virtual BOOL Marked();        //TRUE if has Z3D_FALG_MARKED in nFlags
  virtual BOOL Disabled();      //TRUE if has Z3D_FALG_DISABLED in nFlags
  virtual BOOL Hidden();        //TRUE if has Z3D_FALG_HIDDEN in nFlags

  virtual void Select();        //Adds Z3D_FALG_SELECTED into nFlags
  virtual void UnSelect();      //Removes Z3D_FALG_SELECTED from nFlags
  virtual void Mark();        //Adds Z3D_FALG_MARKED into nFlags
  virtual void UnMark();        //Removes Z3D_FALG_MARKED from nFlags
  virtual void Disable();        //Adds Z3D_FALG_DISABLED into nFlags
  virtual void Enable();        //Removes Z3D_FALG_DISABLED from nFlags
  virtual void Hide();        //Adds Z3D_FALG_HIDDEN into nFlags
  virtual void UnHide();        //Removes Z3D_FALG_HIDDEN from nFlags
  virtual void Select(BOOL set);    //either selects or deselects element
  virtual void Mark(BOOL set);    //either marks or unmarks element
  virtual void Disable(BOOL set);    //either disables or enables element
  virtual void Hide(BOOL set);    //either hides or un-hides element

  // sets new state to faces that are in a custom state
  virtual void ToHasFlagChangeFlag(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
                    BOOL HasntMark, BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
                    BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  // changes state of the faces that are in a custom state
  virtual void ToHasFlagSetFlag(  BOOL HasMark,BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
                  BOOL HasntMark,BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
                  BOOL SetMark,BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  // sets new state to all faces in Table
  virtual void ToAllChangeFlag(  BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
};



#endif

